/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.surveillance;

import com.ibm.hsc.auiml.databeans.sfp.ConnectionMonitorManager;
import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.SFPSettingsData;
import com.ibm.hsc.auiml.databeans.sfp.data.CECStateInformation;
import com.ibm.hsc.auiml.databeans.sfp.data.SFPSettingsInformation;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardBaseTask;
import com.ibm.hsc.iw.WizardCommitStatus;
import com.ibm.hsc.iw.WizardFrame;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.WizardTaskPanel;
import com.ibm.hsc.iw.WizardTaskState;
import com.ibm.hsc.iw.tasks.surveillance.SurveillanceConstants;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;

public class SurveillanceTask
extends WizardBaseTask
implements SurveillanceConstants {
    private static final String ENABLED_EN_US = "Enabled";
    private static final String DISABLED_EN_US = "Disabled";
    private static final String TRACE_MASKD = "JIWZSURD";
    private static final String TRACE_MASKF = "JIWZSURF";
    private static final String TRACE_MASKT = "JIWZSURT";
    private static final String SETTINGS_LOAD_ERROR_MSG = "1101";
    private static final String SETTINGS_SAVE_ERROR_MSG = "1100";
    private static String currentPanel = null;
    private static final String persistKey = (class$com$ibm$hsc$auiml$databeans$sfp$SFPSettingsTasklet == null ? (class$com$ibm$hsc$auiml$databeans$sfp$SFPSettingsTasklet = SurveillanceTask.class$("com.ibm.hsc.auiml.databeans.sfp.SFPSettingsTasklet")) : class$com$ibm$hsc$auiml$databeans$sfp$SFPSettingsTasklet).getName();
    private SFPSettingsInformation settings = new SFPSettingsInformation();
    static /* synthetic */ Class class$com$ibm$hsc$auiml$databeans$sfp$SFPSettingsTasklet;
    static /* synthetic */ Class class$com$ibm$hsc$ccfw$mom$PICec;

    public static synchronized SFPSettingsInformation getConnectionValues() throws SFPException {
        SFPSettingsInformation sFPSettingsInformation = new SFPSettingsInformation();
        int n = 0;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SurveillanceTask.getConnectionValues()");
        }
        try {
            int n2;
            SFPSettingsData sFPSettingsData = new SFPSettingsData();
            SFPSettingsData sFPSettingsData2 = sFPSettingsData.getConnectionData();
            if (sFPSettingsData2 != null) {
                sFPSettingsInformation.connected = sFPSettingsData2.settings.getConnectedTimer();
                sFPSettingsInformation.disconnected = sFPSettingsData2.settings.getDisconnectedTimer();
                sFPSettingsInformation.interval = sFPSettingsData2.settings.getIntervalTimer();
                n = sFPSettingsData2.settings.getCecStateInformation().length;
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "SFPInformation is: " + sFPSettingsInformation + "/nNumber of saved CECs was " + n);
            }
            Vector vector = null;
            try {
                vector = SurveillanceTask.getTargets();
            }
            catch (SFPException sFPException) {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKT, "<- SurveillanceTask.getConnectionValues() getTargets() failed with exception " + sFPException);
                }
                throw sFPException;
            }
            int n3 = n2 = vector == null ? 0 : vector.size();
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "SurveillanceTask.getConnectionValues() number of cecs is " + n2);
            }
            sFPSettingsInformation.stateInformation = new CECStateInformation[n2];
            for (int i = 0; i < n2; ++i) {
                CECStateInformation cECStateInformation = new CECStateInformation();
                String[] stringArray = (String[])vector.get(i);
                cECStateInformation.machineName = stringArray[0];
                cECStateInformation.machineModelType = stringArray[1];
                cECStateInformation.machineSerial = stringArray[2];
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKT, "stateInformation():  \n  Name=" + cECStateInformation.machineName + "\n  ModelType=" + cECStateInformation.machineModelType + "\n  SN=" + cECStateInformation.machineSerial);
                }
                boolean bl = true;
                for (int j = 0; j < n; ++j) {
                    if (!cECStateInformation.getMachineId().equals(sFPSettingsData2.settings.stateInformation[j].getMachineId())) continue;
                    cECStateInformation.surveillanceState = sFPSettingsData2.settings.stateInformation[j].surveillanceState;
                    bl = false;
                    if (2 <= Trace.LEVEL) {
                        // empty if block
                    }
                    Trace.trace(TRACE_MASKF, "State for " + cECStateInformation.machineName + " = " + cECStateInformation.surveillanceState);
                }
                if (bl) {
                    if (2 <= Trace.LEVEL) {
                        // empty if block
                    }
                    Trace.trace(TRACE_MASKF, "State for " + cECStateInformation.machineName + " set to " + ENABLED_EN_US);
                    cECStateInformation.surveillanceState = ENABLED_EN_US;
                }
                sFPSettingsInformation.stateInformation[i] = cECStateInformation;
            }
        }
        catch (SFPException sFPException) {
            if (2 <= Trace.LEVEL) {
                // empty if block
            }
            Trace.trace(TRACE_MASKF, "Error doing SurveillanceTask.getConnectionData() " + sFPException);
            Trace.trace(TRACE_MASKT, "<-SurveillanceTask.getConnectionValues() with error reading persistence data.");
            throw sFPException;
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                // empty if block
            }
            Trace.trace(TRACE_MASKF, "Exception in getConnectionValues()  " + exception);
            throw new SFPException("0149", exception);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SurveillanceTask.getConnectionValues()");
        }
        return sFPSettingsInformation;
    }

    private static void setConnectionValues(SFPSettingsInformation sFPSettingsInformation) throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SurveillanceTask.setConnectionValues()");
        }
        try {
            SFPSettingsData sFPSettingsData = new SFPSettingsData();
            sFPSettingsData.setConnectionData(sFPSettingsInformation);
            Trace.trace(TRACE_MASKF, "Notifying listeners of timer changes");
            ConnectionMonitorManager.getConnectionMonitorManager().notifyTimersChanged(sFPSettingsInformation.getConnectedTimer(), sFPSettingsInformation.getDisconnectedTimer(), sFPSettingsInformation.getIntervalTimer());
        }
        catch (SFPException sFPException) {
            if (2 <= Trace.LEVEL) {
                // empty if block
            }
            Trace.trace(TRACE_MASKF, "Exception doing Persistence.write " + sFPException);
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SurveillanceTask.setConnectionValues() with Persistence exception");
            }
            throw sFPException;
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                // empty if block
            }
            Trace.trace(TRACE_MASKF, "Exception doing Persistence.write " + exception);
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SurveillanceTask.setConnectionValues() with Persistence exception");
            }
            throw new SFPException("0149", exception);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- SurveillanceTask.setConnectionValues()");
        }
    }

    public static void main(String[] stringArray) {
        if (Trace.LEVEL >= 3) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(' ');
                stringBuffer.append(stringArray[i]);
            }
            Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + stringBuffer.toString());
        }
    }

    public LocalizableText getDescription() {
        Object var1_1 = null;
        return new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "SURVEILLANCE_TASK_DESCRIPTION");
    }

    public static Vector getTargets() throws SFPException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> SurveillanceTask.getTargets()");
        }
        Vector<String[]> vector = new Vector<String[]>();
        int n = 0;
        try {
            CommonSystem.getCommonSystem().setLocation(1);
            CommonSystem.getCommonSystem().setSystemUserContext(new UserContext(null, null, 3, null, Locale.getDefault()));
            ManagedObjectManager managedObjectManager = ManagedObjectManager.getManagedObjectManager();
            Set set = managedObjectManager.getInventory(new ClassId(class$com$ibm$hsc$ccfw$mom$PICec == null ? (class$com$ibm$hsc$ccfw$mom$PICec = SurveillanceTask.class$("com.ibm.hsc.ccfw.mom.PICec")) : class$com$ibm$hsc$ccfw$mom$PICec));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                PICec pICec = (PICec)iterator.next();
                String[] stringArray = new String[]{pICec.getUserDefinedName(), pICec.getMachineType() + "-" + pICec.getModel(), pICec.getSerialNumber()};
                vector.add(stringArray);
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "-- CEC found, MTMS: " + stringArray[0] + " UserName: " + stringArray[1]);
                }
                ++n;
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "-- total objects retrieved is: " + n);
            }
        }
        catch (Exception exception) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Exception getting CEC Information: " + exception);
            }
            throw new SFPException(exception.toString());
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "Number of targets returned is " + n);
        }
        Trace.trace(TRACE_MASKT, "<- SurveillanceTask.getTargets()");
        return vector;
    }

    public WizardTaskState init(WizardFrame wizardFrame) throws WizardTaskException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SurveillanceTask.init()");
        }
        try {
            this.settings = SurveillanceTask.getConnectionValues();
        }
        catch (SFPException sFPException) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Exception getting surveillance information: " + sFPException);
            }
            new AusMicrocodeLog(LOG_INFO, 2, sFPException).writeEntry(null);
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SurveillanceTask.init() failed with exception " + sFPException);
            }
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "SURVEILLANCE_TASK_EXTENSION", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", sFPException.getKey(), null));
        }
        this.settings.panelName = "SFPLanSurveillance1";
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "SurveillanceTask.init() has retrieved timers: connected(" + this.settings.connected + ") disconnected(" + this.settings.disconnected + ") interval(" + this.settings.interval + ")");
        }
        currentPanel = "SFPLanSurveillance1";
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SurveillanceTask.init()");
        }
        return new WizardTaskState(SurveillanceTask.getPanel("SFPLanSurveillance1"), this.settings);
    }

    private static WizardTaskPanel getPanel(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SurveillanceTask.getPanel(" + string + ")");
        }
        WizardTaskPanel wizardTaskPanel = null;
        Object var2_2 = null;
        if (string.equals("SFPLanSurveillance1")) {
            wizardTaskPanel = new WizardTaskPanel("com.ibm.hsc.iw.tasks.surveillance.res.SFPSurveillanceWizard", "SFPLanSurveillance1", "com.ibm.hsc.iw.tasks.surveillance.SurveillanceBean");
            currentPanel = "SFPLanSurveillance1";
        } else {
            wizardTaskPanel = new WizardTaskPanel("com.ibm.hsc.iw.tasks.surveillance.res.SFPSurveillanceWizard", "SFPLanSurveillance2", "com.ibm.hsc.iw.tasks.surveillance.SurveillanceBean");
            currentPanel = "SFPLanSurveillance2";
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SurveillanceTask.getPanel()");
        }
        return wizardTaskPanel;
    }

    public void exit() {
    }

    public WizardTaskState nextButtonHit(Serializable serializable) throws WizardTaskException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SurveillanceTask.nextButtonHit()");
        }
        SFPSettingsInformation sFPSettingsInformation = (SFPSettingsInformation)serializable;
        WizardTaskPanel wizardTaskPanel = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SurveillanceTask.nextButtonHit(null)");
        }
        return new WizardTaskState(wizardTaskPanel, sFPSettingsInformation);
    }

    public Object backButtonHit(Serializable serializable) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SurveillanceTask.backButtonHit()");
        }
        Object var2_2 = null;
        SFPSettingsInformation sFPSettingsInformation = (SFPSettingsInformation)serializable;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SurveillanceTask.backButtonHit(null)");
        }
        return serializable;
    }

    public Object backedIntoPanel(WizardTaskState wizardTaskState) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SurveillanceTask.backedIntoPanel()");
        }
        SFPSettingsInformation sFPSettingsInformation = null;
        sFPSettingsInformation = (SFPSettingsInformation)wizardTaskState.getToken();
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "Current SFPSettingsInformation is: " + sFPSettingsInformation);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SurveillanceTask.backedIntoPanel()");
        }
        return sFPSettingsInformation;
    }

    public LocalizableText[] prepareToCommit(Object object) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> Surveillance.prepareToCommit()");
        }
        SFPSettingsInformation sFPSettingsInformation = null;
        LocalizableText localizableText = null;
        sFPSettingsInformation = (SFPSettingsInformation)object;
        if (sFPSettingsInformation.pendingChanges) {
            localizableText = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "SURVEILLANCE_COMMIT");
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<- Surveillance.prepareToCommit(message)");
            }
            LocalizableText[] localizableTextArray = new LocalizableText[]{localizableText};
            return localizableTextArray;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- Surveillance.prepareToCommit(null)");
        }
        return null;
    }

    public WizardCommitStatus commit(Object object) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> Surveillance.commit()");
        }
        Object var2_2 = null;
        boolean bl = false;
        HSCLocalizableMsg[] hSCLocalizableMsgArray = new HSCLocalizableMsg[1];
        Object[] objectArray = new String[1];
        SFPSettingsInformation sFPSettingsInformation = (SFPSettingsInformation)object;
        try {
            SurveillanceTask.setConnectionValues(sFPSettingsInformation);
            bl = true;
        }
        catch (SFPException sFPException) {
            bl = false;
            objectArray[0] = sFPException.toString();
        }
        hSCLocalizableMsgArray[0] = bl ? new HSCLocalizableMsg(MsgType.INFORMATION_MESSAGE, "W", "com.ibm.hsc.common.bundles.SFPResourceBundleMessages", "0151", null) : new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.SFPResourceBundleMessages", "0150", objectArray);
        if (bl) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<- Surveillance.commit(success)");
            }
            return new WizardCommitStatus(bl, hSCLocalizableMsgArray);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- Surveillance.commit(error)");
        }
        return new WizardCommitStatus(bl, hSCLocalizableMsgArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

